*** COS 2018 11, last update 2023 02  
           
program define dq_fil_met, rclass  
syntax , metadatafile(string) [sd(string) language(string) 																															///  
		 keyvars(string) minorvars(string) processvars(string) controlvars(string) observervars(string) devicevars(string) centervars(string) timevars(string)  idvars(string) 		///  
		 segmentname(string) segmentselect(string) varselect(string) minvarnum(int 1) benchmark(int 0)  breakreport(int 0) indent (int 0)]						///  
		 [macroextensionname(string) columnrequest(string) infotype(int 0) sheetname(string) checkvarlist(string) lowercase(int 1) useall dataquieR]  
	          
local metadataexist=0  
local indent=`indent'+5  
local adoname "dq_fil_met"  
local text_i "di as text _n "  					  
local reportstop=0														  
return local  metadatalines=0											  
dq_fil_exc, cdir("`sd'") cfile(`metadatafile') sheetname(`sheetname') filetype(Metadata)  indent(`indent')  
if `reportstop'==0 local reportstop = r(reportstop)						  
	          
if `reportstop'==0 {  
	mata: nvar=st_nvar()  
	mata: st_numscalar("nvar",nvar)		  
	local nvar=nvar  
	mata: nobs=st_nobs()  
	mata: st_numscalar("nobs",nobs)		  
	local nobs=nobs  
	return local  metadatalines=`nobs'  
	if `nobs'==0 {  
		*** DQ_quality_decision: 	DQ_INT_2  
		         
	    local reportstop=1	  
		di       
		`text_i' "Fatal problem: The metadatafile does not provide information on any study variable  "  
		`text_i' "Data Quality Classification:  Indicator: Unexpected data elements; Implementation form: Unavailable metadata elements" _n  
		dq_out_add ,  tablename(integtable_metadata) row(integtablerows_metadata) columns(3) colcontent1("$Critical_1") colcontent2("`metadatafile'") colcontent3(Indicator: Data elements unavailable - $DQ_INT_critical_17)  indent(`indent')	  
	}         
	*** Specific operations for study data related metadata : infotype=0  
	          
	if `infotype'==0 & `reportstop'==0 {											  
		if "`dataquieR'"=="dataquieR" {  
		    dq_met_dtq,  indent(`indent')	  
			mata: nvar=st_nvar()  
			mata: st_numscalar("nvar",nvar)		  
			local nvar=nvar  
		}        
		if `lowercase'==1 {  
			foreach var of varlist _all {  
				qui rename `var', lower  
			}       
		}        
		         
		** Drop all lines with variablerole = exclude if such variable present  
		capture confirm variable variablerole  
		if _rc==0 qui drop if variablerole=="exclude"  
		         
		local segmentname = lower("`segmentname'")  
		         
		*** Shorten specific long variable names to avoid long scalar names - HOTFIX for SHIP to avoid lengthy macro names  
		capture rename limit_soft_low 		lim_sl	  
		capture rename limit_soft_up		lim_su  
		capture rename limit_hard_low		lim_hl  
		capture rename limit_hard_up		lim_hu  
		         
		capture rename variable_order		var_order  
		capture rename short_name			var_name  
		         
		         
		if `lowercase'==1 {  
			capture confirm string variable var_name  
			if _rc==0 {  
				qui replace var_name=lower(var_name)  
			}       
		}        
		         
		local columnrequest=subinstr("`columnrequest'", "limit_soft_low", "lim_sl", 1)  
		local columnrequest=subinstr("`columnrequest'", "limit_soft_up", "lim_su", 1)  
		local columnrequest=subinstr("`columnrequest'", "limit_hard_low", "lim_hl", 1)  
		local columnrequest=subinstr("`columnrequest'", "limit_hard_up", "lim_hu", 1)  
		         
		qui ds   
		local metavarlist "`r(varlist)'"		  
		         
		capture ds(`segmentname')  
		if _rc>0   {  
			di as error "Fatal problem: A requested metadata element has not been found. Please correct and restart. "  
			*** DQ_process_decision: DQ_INT_20  
			local reportstop=1					  
			dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) ///  
											colcontent1("$Critical_1") colcontent2("segmentname") ///  
											colcontent3($DQ_INT_critical_20 $Variable_1 `segmentname')  indent(`indent') 	  
		}        
			        
		tempvar varpreselect				  
		if "`varselect'"~="" {				  
			capture ds(`varselect')  
			if _rc>0   {  
				`text_i' "Fatal problem: The variable specified to identify variable selection does not exist. Please correct and restart. "  
				*** DQ_process_decision: DQ_INT_20  
				local reportstop=1					  
				dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) ///  
												colcontent1("$Critical_1") colcontent2("varselect") ///  
												colcontent3($DQ_INT_critical_20 $Variable_1 `segmentname')  indent(`indent') 	  
				qui gen `varpreselect'="."  
			}       
			 else qui gen `varpreselect'=trim(`varselect')			  
		}        
		if "`varselect'"=="" {  
		   qui gen `varpreselect'="1"							//	If nothing specified everything can be selected						  
		}        
		tempvar includevar																		  
		qui gen `includevar'=.																	  
 	         
		if "`checkvarlist'"~="" {																  
			foreach var in `checkvarlist' {														  
				capture confirm variable var_name												  
				if _rc==0 qui replace `includevar'=1 if var_name=="`var'" 						  
			}       
		}        
		if trim("`keyvars'`minorvars'")=="" & "`segmentname'"~="" & "`segmentselect'"~="nosegmentselect"  {		  
			if "`segmentselect'"~="" {															  
				qui replace `includevar'=1 	if `segmentname'=="`segmentselect'"	& `varpreselect'=="1"  
				capture qui if "`idvars'"=="" replace `includevar'=1 if variablerole=="idvars" 	  
			}       
		}        
		         
		if trim("`keyvars'`minorvars'")=="" & "`segmentselect'"=="nosegmentselect" {			  
				qui replace `includevar'=1 	if `varpreselect'=="1"													  
		}        
		local checkprocesstrings ""  
		if "`observervars'"=="" local checkprocesstrings = "key_observer"  
		if "`devicevars'"=="" 	local checkprocesstrings = "`checkprocesstrings' key_device"  
		if "`centervars'"=="" 	local checkprocesstrings = "`checkprocesstrings' key_center"  
		if "`timevars'"=="" 	local checkprocesstrings = "`checkprocesstrings' key_datetime"  
		         
		local foundprocesstrings ""																  
		         
		foreach var in `checkprocesstrings' {													  
			qui capture confirm variable `var'														  
			if _rc==0 {  
				 qui levelsof `var' if `includevar'==1, clean  
				 local foundprocesstrings "`foundprocesstrings' `r(levels)'"			  
			}       
		}        
           
		capture confirm variable var_name															  
		if _rc==0 {  
			foreach processvar of local foundprocesstrings {  
				qui replace `includevar'=1 if var_name=="`processvar'" 								  
			}			    
			if "`useall'"=="" qui keep if `includevar'==1											  
			`text_i' "Metadata information on the following study variable subselection will be used:"  
			list var_name if `includevar'==1  
			di      
		}        
		qui drop `includevar' 													  
		qui drop `varpreselect'													  
		mata: nobs=st_nobs()  
		mata: st_numscalar("nobs",nobs)		  
		local nobs=nobs  
		return local  metadatalines=`nobs'		  
		         
	}         
}          
	          
** Conduct further checks and actions for transfer of information to scalars and globals  
if `reportstop'==0 {				  
	if `infotype'==0 {				  
		if strpos("`metavarlist'", "var_order")>0 {  
			capture confirm string var var_order  
			if _rc ==0 {  
				capture destring var_order, replace  
				if _rc ==0 {  
					*** DQ_quality_decision: DQ_INT_8, Dimension:Integrity, Domain: Value format error, Indicator: Data type mismatch  
					di    
					`text_i' "Issue: The order variable is a string format instead of numeric and could not be converted."  
					`text_i' "Data Quality Classification:  Indicator: Data type mismatch; Implementation form: Numerical as string mismatch " _n  
					dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) ///  
													colcontent1("$Warning_1") colcontent2("Metavariable: varorder") colcontent3($DQ_INT_issue_9)  indent(`indent')  
				}      
			}       
			sort var_order  
		}        
	} 	       
	*** Generate scalar to host the name of all used variables  
	if strpos("`metadatafile'","\")>0 {  
		if `infotype'==0  local metavarlistname "defaultname"  
		if `infotype'==1  local metavarlistname "languagefile"  
		if `infotype'==2  local metavarlistname "dataqualityfile"  
		if `infotype'==3  local metavarlistname "interpretationtext"  
		if `infotype'==4  local metavarlistname "resultscalardatafile"  
	}         
	          
	local metadatastub=subinstr("`metadatafile'",".xlsx","",.)  
	if "`metadatastub'"==""  local metadatastub=subinstr("`metadatafile'",".xls","",.)  
	if "`metadatastub'"==""  local metadatastub=subinstr("`metadatafile'",".dta","",.)  
	if strpos("`metadatafile'","\")==0 local metavarlistname=substr("metavars_`metadatastub'_`sheetname'",1,32)  
	          
	*scalar `metavarlistname'=""	  
	          
	          
	*** Read metadata into scalars only for non text output related content  
	          
	if `infotype'==4  	{  
	    qui tostring modified, replace	  
		order pointer var_name varlabel varshortlabel, before(variablerole)		  
		foreach vartype in idvars keyvars minorvars processvars  {  
			local `vartype' "" 						  
		}        
	}         
	          
	local column=1  
	while (`column' <= `nvar' )  {  
	          
		local row=1															//	initialize row vector  
		         
		mata: metadatatype=st_varname(`column')  
		mata: st_strscalar("metadatatype",metadatatype)  
		local metadatatype`column'=metadatatype	  
		         
		if `infotype'==4  	{										  
			local checkvar `=metadatatype'  
			if "`checkvar'"~="segment" {  
				qui tostring `checkvar', replace force					  
			}       
		}        
		         
		if "`columnrequest'"=="" | strpos("`columnrequest'","`metadatatype`column''")>0 {  
			        
			* Assign scalar with list of variables  
			*scalar `metavarlistname'="`=`metavarlistname'' `metadatatype`column''"		  
			while (`row' <= `nobs' ) 	{  
				* Create correct scalar name  
				local scalarname `metadatatype`column''`macroextensionname'`row'  
				if `infotype'==4  	{										  
					if modified[`row']=="1" local macroextensionname "mpt"  
					if modified[`row']=="0" local macroextensionname "pt"										  
					local pointernumber=pointer[`row']  
					local scalarname `metadatatype`column''_`macroextensionname'`pointernumber'  
				}      
				       
				* Transfer content from data set to scalars  
				mata: fieldcontent=_st_sdata(`row', `column')				  
				mata: st_strscalar(`"`scalarname'"',fieldcontent)			  
				* Edit scalar content - delete quotation marks  
				if strpos(`"`=`scalarname''"', `"""')>0 {  
					scalar `scalarname' = subinstr(`"`=`scalarname''"', `"""', "", .)  
				}      
				scalar `scalarname' = strtrim("`=`scalarname''")  
				       
				if `infotype'==0 | `infotype'==4 {  
					if "`metadatatype`column''"=="variablerole"	{	  
						if `infotype'==4 {  
							local vn=var_name[`row']		  
							capture ds *varmax*  
							if _rc==0 {  
								local dqvarmax "`r(varlist)'"  
							}   
							    
						}    
						     
						foreach vartype in idvars keyvars minorvars processvars controlvars observervars devicevars centervars timevars {  
							if "`=`scalarname''"== "`vartype'" 	{  
								if `infotype'==0 {  
								    local `vartype' "``vartype'' `=var_name_mdpt`row''" 			  
								}  
								if `infotype'==4 {  
									local append=0  
									if modified[`row']=="0" local append=1							  
									capture confirm numeric variable `dqvarmax'  
									if  _rc==0 {	  
										if `dqvarmax'[`row']<`benchmark' local append=0					  
									}  
									if `append'==1 {  
										local `vartype'=trim("``vartype'' `vn'") 					  
									}  
								}  
								return local `vartype'="``vartype''" 								  
							}   
						}    
					}     
					      
					if "`metadatatype`column''"=="sourcefilename"	{  
						local addvar=1																  
						foreach var in `targetfiles' {  
							if "`=`scalarname''"=="`var'" {  
								local addvar=0	  
							}   
						}	   
						if `addvar'==1 {  
							local targetfiles="`targetfiles' `=`scalarname''"						  
						}    
						return local targetfiles="`targetfiles'"  
					}	    
					      
				}      
				       
				local row=`row'+1  
			}	      
			        
		}        
		         
		if `infotype'==4  & "`checkvar'"~="modified"	{		  
			qui destring `checkvar', replace 	  
		}        
		         
		local column=`column'+1  
	}         
	          
	          
	          
	          
	if `infotype'==4 {		  
		local row=1  
		local nvars=`nobs'/2		  
		while (`row' <= `nvars' ) 	{  
			        
			global `=var_name_pt`row'' 	= 		"pt`=pointer_pt`row''"			  
			global `=var_name_mpt`row'' = 		"mpt`=pointer_mpt`row''"  
			        
			local backpt "pt`=pointer_pt`row''"  
			global `backpt'   =  	"mdpt`=pointer_pt`row''"		  
			local backmpt "pt`=pointer_mpt`row''"  
			global `backmpt'  =  	"mdpt`=pointer_pt`row''"					  
			        
			local row=`row'+1  
		}        
		         
		qui destring modified, replace 	  
	}         
	if `infotype'==0  {  
		if `nobs'< `minvarnum'  & "`keyvars'"=="" {  
			`text_i' "The number of variables is lower than required for a full report. No report conducted. "  
			*** DQ_process_decision: DQ_INTcall_8  
			local reportstop=1					  
			dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) colcontent1("$Warning_1")  colcontent2("Insufficient analysis variable count.") colcontent3($DQ_INTcall_issue_8.  `nobs'< `minvarnum')  indent(`indent') 	  
			dq_out_add ,  tablename(integtable_commandcall) row(integtablerows_commandcall) columns(3) colcontent1("$Action_1") colcontent2("Insufficient analysis variable count.") colcontent3($DQ_INTcall_action_8)  indent(`indent') 	  
		}        
	}         
	          
	          
	if `infotype'==1 {  
		local row=1													//	initialize row vector  
		dq_hlp_vc, targetvariable("Texttype")  indent(`indent')  
		local texttypecol 	`r(varcol)'  
		dq_hlp_vc, targetvariable("Language")  indent(`indent')  
		local languagecol 	`r(varcol)'  
		dq_hlp_vc, targetvariable("Textcontent")  indent(`indent')  
		local textcontentcol `r(varcol)'  
		* Transfer scalars to globals and delete scalars  
		while (`row' <= `nobs' ) 	{  
			local text "`=`metadatatype`texttypecol''`macroextensionname'`row''"					  
			if "`language'"=="`=`metadatatype`languagecol''`macroextensionname'`row''" {			  
				global `text' `"`=`metadatatype`textcontentcol''`macroextensionname'`row''"' 		  
			}	      
			* Delete scalars as necessary information is stored in globals  
			capture scalar drop `metadatatype`texttypecol''`macroextensionname'`row'  `metadatatype`languagecol''`macroextensionname'`row' `metadatatype`textcontentcol''`macroextensionname'`row'  
			local row=`row'+1  
		}	       
	}         
	          
	if `infotype'==2 {  
		dq_hlp_vc, targetvariable("dqi_parameterstub")  indent(`indent')  
		local parameterstubcol `r(varcol)'  
		local row=1																//	initialize row vector  
		while (`row' <= `nobs' ) 	{  
			* Create pointer scalars the pointer must point to the  dqi_parameterstub column  
			local dqipointer "`=`metadatatype`parameterstubcol''`macroextensionname'`row''"  
			scalar  `dqipointer'`macroextensionname'= `row'									  
			local row=`row'+1  
		}	       
		scalar dqi_number`macroextensionname' =`row'-1							  
	}         
	*** Drop superfluous scalar  
	scalar drop metadatatype nobs nvar  
	          
}          
return local reportstop=`reportstop'											  
end        
